﻿/*****************************************************************************************************
* $$FileName		Show unused topics in Browse Sequence.jsx
*
* $$Description		Sample ExtendScript file to Display all the topics which are not used in the Browse Sequence.
*
* Copyright (c) 2009 Adobe Systems Incorporated. All Rights Reserved.
******************************************************************************************************/
main();
var brsArray;
var unusedArray;
function main()
{
	brsArray = new Array();
	unusedArray= new Array();
	ReadBrowseSequenceFile();
	var topicmanager = RoboHelp.project.TopicManager;
	var topic;
	for(var index=1;index<=topicmanager.count;index++)
	{
		topic = topicmanager.item(index);
		if(!IsTopicInBrowseSequence(topic))
		{
			//this fopic is not in Browse Sequene
			AddTopicToOutputList(topic);
		}
	}
	DisplayUnusedTopics();
}

//this function read the browse sequence file and update the brsArray with all the topics .
function ReadBrowseSequenceFile()
{
	var brsFile = RoboHelp.project.path+'\\'+RoboHelp.project.name+'.brs';
	var tokenmgr = RoboHelp.getTokenManager(brsFile);
	var topicLink="";
	if(typeof(tokenmgr)!='undefined')
	{
		if(tokenmgr.count>0)
		{
			var token = tokenmgr.item(1);
			while(typeof(token)!='undefined')
			{
				//for each token, get the link attribute
				topicLink = token.getAttribute('link');
				if(typeof(topicLink)!='undefined'  && topicLink.length>0)
				{
					brsArray[brsArray.length]=topicLink.toLowerCase();
				}
				token = token.next;
			}
		}
	}
}

function outputMsg(szString)
{
	RoboHelp.project.outputMessage (szString);
}

function AddTopicToOutputList(topic)
{
	unusedArray[unusedArray.length]=topic;
}

//this function search the brsArray and finds out if the topic provided is already a part of browse sequence or not
function IsTopicInBrowseSequence(topic)
{
	var relativePath = GetRelativePath(topic.path);
	relativePath = relativePath.toLowerCase();
	//check if this topic is present in the browse sequence array
	var bRetVal = false;
	for(var index=0;index<brsArray.length;index++)
	{
		if(relativePath == brsArray[index])
		{
			bRetVal = true;
			break;
		}
	}
	return bRetVal;
}

//this function read the unusedArray and display all the topics in the output pane
function DisplayUnusedTopics()
{
	//we have to check the unusedArray and output them now
	var topic;
	if(unusedArray.length>0)
	{
		outputMsg ("\n\nFollowing are the Topics not used in Browse Sequence:\n");
		for(var index=0;index<unusedArray.length;index++)
		{
			topic = unusedArray[index];
			outputMsg("\t\t ---> "+topic.name+'\t\t\t --->'+GetRelativePath (topic.path)+'\n');
		}
	}
	else
	{
		outputMsg ("\n\nThere are no unused Topics present\n");
	}
}

//this function provides a relative path of topic.
function GetRelativePath(topicPath)
{
	var projectpath = RoboHelp.project.path;
	var index = topicPath.indexOf(projectpath);
	if(index==0)
	{
		topicPath = topicPath.substr(projectpath.length+1);
	}
	else
	{
		alert('error check here');
	}
	return topicPath;
}

